/*
 * JobCenter.h
 *
 *  Created on: 25.11.2009
 *      Author: stefan.detter
 */

#ifndef JOBCENTER_H_
#define JOBCENTER_H_

#include <QObject>
#include <QVariant>
#include <QQueue>

#include <def.h>

class QrfeReaderManager;
class GuiController;
class ReaderControll;
class FirmwareUpdateManager;
class TraceWindowManager;
class ToolController;

typedef struct {
	JobType				jobType;
	QList<QVariant>		parameters;
} Job;

class JobCenter : public QObject
{
	Q_OBJECT
public:
	JobCenter(QrfeReaderManager* manager, GuiController* gui, ReaderControll* controll,
			FirmwareUpdateManager* updateManager, TraceWindowManager* traceWindowManager, ToolController* toolController, QWidget* mainWindow, QObject* parent = 0);
	virtual ~JobCenter();

public slots:
	void appendJop(JobType type, const QList<QVariant>& parameters);
	void processJobs();

private:
	void showHideTraceWindow(QList<QVariant> &params);

	void waitForSpecifiedTime(QList<QVariant> &params);
	void waitForSpecifiedTimeWithDialog(QList<QVariant> &params);

	void addReader(QList<QVariant> &params);
	void checkReaderForUpdates(QList<QVariant> &params);

	void switchReaderToBootloader(QList<QVariant> &params);
	void switchReaderToBootloaderAndShowDialog(QList<QVariant> &params);
	void switchReaderToFirmware(QList<QVariant> &params);
	void switchReaderSystemWithoutCommand(QList<QVariant> &params);
	void switchReaderSystemWithoutCommandAndShowSettings(QList<QVariant> &params);

	void startScan(QList<QVariant> &params);
	void stopScan(QList<QVariant> &params);

	void showApplicationSettings(QList<QVariant> &params);
	void showSettingsOfReader(QList<QVariant> &params);
	void showAppSettingsOfReader(QList<QVariant> &params);
	void showEngineeringForReader(QList<QVariant> &params);
	void showSettingsOfTag(QList<QVariant> &params);
	void showEngineeringForTag(QList<QVariant> &params);

	void startTool(QList<QVariant> &params);

private:
	QQueue<Job>			m_jobList;

	QrfeReaderManager* 	m_manager;
	GuiController* 		m_guiController;
	ReaderControll*		m_controll;
	FirmwareUpdateManager* 		m_updateManager;
	TraceWindowManager* m_traceWindowManager;
	ToolController* 	m_toolController;
	QWidget* 			m_mainWindow;
};

#endif /* JOBCENTER_H_ */
